#include "General.h"
#include "Taunts.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

Taunts::Taunts()
{
	RegisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
}

Taunts::~Taunts()
{
	UnregisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
}

void Taunts::OnObjectCreate(void *data,GameObject *obj)
{
	if (Commands->Is_A_Star)
	{
		Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt1,h_a_a0a0_l12");
		Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt2,H_A_a0a0_L22");
		Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt3,H_A_a0a0_L23");
		Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt4,H_A_a0a0_L24");
		Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt5,H_A_a0a0_L25");
		Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt6,H_A_a0a0_L58");
		Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt7,H_A_cresentkick");
		Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt8,H_A_sidekick");
		Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt9,H_A_punchcombo");
	}
}

void KeyHookCall(void *Data2) {
	MDB_SSGM_KeyHook_Clone *Base = (MDB_SSGM_KeyHook_Clone *)Data2;
	Base->KeyHookFunc();
}

int MDB_SSGM_KeyHook_Clone::AddHook(const char *Key, GameObject *obj) {
	if (is_keyhook_set == 1337) {
		RemoveHook();
	}
	k = 0;
	k = new KeyHookStruct;
	k->data = this;
	k->hook = KeyHookCall;
	k->PlayerID = Get_Player_ID(obj);
	k->key = newstr(Key);
	hookid = AddKeyHook(k);
	return hookid;
}

void MDB_SSGM_KeyHook_Clone::RemoveHook() {
	if (hookid != 0 && RemoveKeyHook != 0) {
		RemoveKeyHook(hookid);
		hookid = 0;
		if (k != 0) {
			delete[] k->key;
			delete k;
			k = 0;
		}
	}
}

void MDB_SSGM_KeyHook_Clone::Detach(GameObject *obj) {
	if (is_keyhook_set == 1337) {
		RemoveHook();
	}
}

void MDB_SSGM_KeyHook_Clone::Destroyed(GameObject *obj) {
	if (is_keyhook_set == 1337) {
		RemoveHook();
	}
}

void Iran_SSGM_Taunt_Key_Fixed::Created(GameObject *obj) {
	if (is_keyhook_set != 1337) {
		hookid = AddHook(Get_Parameter("Key"),obj);
		is_keyhook_set = 1337;
		can_use_taunts = true;
	}
}

void Iran_SSGM_Taunt_Key_Fixed::KeyHookFunc() {
	if (Get_Vehicle(Owner()) == 0) {
		Commands->Start_Timer(Owner(),this,0.1f,442);
	}
}

void Iran_SSGM_Taunt_Key_Fixed::Timer_Expired(GameObject *obj,int number) {
float oldpos2;

	if (number == 442) {
		oldpos = Commands->Get_Position(Owner());
		Commands->Start_Timer(Owner(),this,0.1f,443);
		oldpos2 = oldpos.Z;
	}
	if ((number == 443) && (can_use_taunts == true)){
		can_use_taunts = false;
		newpos = Commands->Get_Position(Owner()); //New position 0.5 seconds later

		if ((oldpos.Z - newpos.Z) < (float)1.000000 ) {
			Commands->Set_Animation(Owner(),Get_Parameter("Anim"),false,0,0.0f,-1.0f,false); //play animation if Z-height didn't change within a certain threshold in those 0.5 secs
			Commands->Start_Timer(Owner(),this,5,444); //Timer to limit use of taunts to every 5 secs
		}
	}
	if (number == 444) {
	can_use_taunts = true;
	}
}

ScriptRegistrant<Iran_SSGM_Taunt_Key_Fixed> MMDB_SSGM_Taunt_Key_Registrant("MDB_SSGM_Taunt_Key","Key:string,Anim:string");

Taunts taunts;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &taunts;
}
